import { Component, OnInit } from '@angular/core';
import { NgRedux, select } from 'ng2-redux';
import { IAppState } from '../../../store';

import {
  CLEAR_FILTERS
} from '../../../actions';

@Component({
  selector: 'app-bookmark-toolbar',
  templateUrl: './bookmark-toolbar.component.html',
  styleUrls: ['./bookmark-toolbar.component.scss']
})
export class BookmarkToolbarComponent implements OnInit {
  @select(['system', 'focusedElement']) focusedElement;
  constructor(
    private ngRedux: NgRedux<IAppState>) { }

  ngOnInit() {
  }

  getState() {
    return this.ngRedux.getState();
  }

  getFilteredTagMessage() {
    // this needs to be updated in add mvp
    const tag = this.getState().bookmark.currentFilterTag;
    return `Clear filter ${tag.name}`;
  }


  filterTagExists() {
    return this.getState().bookmark.filteredBookmarks.length > 0 ? true : false;
  }

  resetBookmarkList() {
    this.ngRedux.dispatch({
      type: CLEAR_FILTERS,
      payload: this.getState().bookmark.bookmarks
    });
  }
}
